/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.AnalyticsConfiguration;
import software.amazon.awssdk.services.s3.model.AnalyticsConfigurationListCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBucketAnalyticsConfigurationsResponse
extends S3Response
implements ToCopyableBuilder<Builder, ListBucketAnalyticsConfigurationsResponse> {
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListBucketAnalyticsConfigurationsResponse.getter(ListBucketAnalyticsConfigurationsResponse::isTruncated)).setter(ListBucketAnalyticsConfigurationsResponse.setter(Builder::isTruncated)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ContinuationToken").getter(ListBucketAnalyticsConfigurationsResponse.getter(ListBucketAnalyticsConfigurationsResponse::continuationToken)).setter(ListBucketAnalyticsConfigurationsResponse.setter(Builder::continuationToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuationToken").unmarshallLocationName("ContinuationToken").build()).build();
    private static final SdkField<String> NEXT_CONTINUATION_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextContinuationToken").getter(ListBucketAnalyticsConfigurationsResponse.getter(ListBucketAnalyticsConfigurationsResponse::nextContinuationToken)).setter(ListBucketAnalyticsConfigurationsResponse.setter(Builder::nextContinuationToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextContinuationToken").unmarshallLocationName("NextContinuationToken").build()).build();
    private static final SdkField<List<AnalyticsConfiguration>> ANALYTICS_CONFIGURATION_LIST_FIELD = SdkField.builder(MarshallingType.LIST).memberName("AnalyticsConfigurationList").getter(ListBucketAnalyticsConfigurationsResponse.getter(ListBucketAnalyticsConfigurationsResponse::analyticsConfigurationList)).setter(ListBucketAnalyticsConfigurationsResponse.setter(Builder::analyticsConfigurationList)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsConfiguration").unmarshallLocationName("AnalyticsConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(AnalyticsConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()).build()).isFlattened(true).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_TRUNCATED_FIELD, CONTINUATION_TOKEN_FIELD, NEXT_CONTINUATION_TOKEN_FIELD, ANALYTICS_CONFIGURATION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBucketAnalyticsConfigurationsResponse.memberNameToFieldInitializer();
    private final Boolean isTruncated;
    private final String continuationToken;
    private final String nextContinuationToken;
    private final List<AnalyticsConfiguration> analyticsConfigurationList;

    private ListBucketAnalyticsConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.isTruncated = builder.isTruncated;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.analyticsConfigurationList = builder.analyticsConfigurationList;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public final boolean hasAnalyticsConfigurationList() {
        return this.analyticsConfigurationList != null && !(this.analyticsConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsConfiguration> analyticsConfigurationList() {
        return this.analyticsConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContinuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalyticsConfigurationList() ? this.analyticsConfigurationList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketAnalyticsConfigurationsResponse)) {
            return false;
        }
        ListBucketAnalyticsConfigurationsResponse other = (ListBucketAnalyticsConfigurationsResponse)obj;
        return Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.nextContinuationToken(), other.nextContinuationToken()) && this.hasAnalyticsConfigurationList() == other.hasAnalyticsConfigurationList() && Objects.equals(this.analyticsConfigurationList(), other.analyticsConfigurationList());
    }

    public final String toString() {
        return ToString.builder("ListBucketAnalyticsConfigurationsResponse").add("IsTruncated", this.isTruncated()).add("ContinuationToken", this.continuationToken()).add("NextContinuationToken", this.nextContinuationToken()).add("AnalyticsConfigurationList", this.hasAnalyticsConfigurationList() ? this.analyticsConfigurationList() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "ContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "NextContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.nextContinuationToken()));
            }
            case "AnalyticsConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.analyticsConfigurationList()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("ContinuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("NextContinuationToken", NEXT_CONTINUATION_TOKEN_FIELD);
        map.put("AnalyticsConfiguration", ANALYTICS_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBucketAnalyticsConfigurationsResponse, T> g) {
        return obj -> g.apply((ListBucketAnalyticsConfigurationsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private String continuationToken;
        private String nextContinuationToken;
        private List<AnalyticsConfiguration> analyticsConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketAnalyticsConfigurationsResponse model) {
            super(model);
            this.isTruncated(model.isTruncated);
            this.continuationToken(model.continuationToken);
            this.nextContinuationToken(model.nextContinuationToken);
            this.analyticsConfigurationList(model.analyticsConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final List<AnalyticsConfiguration.Builder> getAnalyticsConfigurationList() {
            List<AnalyticsConfiguration.Builder> result = AnalyticsConfigurationListCopier.copyToBuilder(this.analyticsConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyticsConfigurationList(Collection<AnalyticsConfiguration.BuilderImpl> analyticsConfigurationList) {
            this.analyticsConfigurationList = AnalyticsConfigurationListCopier.copyFromBuilder(analyticsConfigurationList);
        }

        @Override
        public final Builder analyticsConfigurationList(Collection<AnalyticsConfiguration> analyticsConfigurationList) {
            this.analyticsConfigurationList = AnalyticsConfigurationListCopier.copy(analyticsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyticsConfigurationList(AnalyticsConfiguration ... analyticsConfigurationList) {
            this.analyticsConfigurationList(Arrays.asList(analyticsConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyticsConfigurationList(Consumer<AnalyticsConfiguration.Builder> ... analyticsConfigurationList) {
            this.analyticsConfigurationList(Stream.of(analyticsConfigurationList).map(c -> (AnalyticsConfiguration)((AnalyticsConfiguration.Builder)AnalyticsConfiguration.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBucketAnalyticsConfigurationsResponse build() {
            return new ListBucketAnalyticsConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBucketAnalyticsConfigurationsResponse> {
        public Builder isTruncated(Boolean var1);

        public Builder continuationToken(String var1);

        public Builder nextContinuationToken(String var1);

        public Builder analyticsConfigurationList(Collection<AnalyticsConfiguration> var1);

        public Builder analyticsConfigurationList(AnalyticsConfiguration ... var1);

        public Builder analyticsConfigurationList(Consumer<AnalyticsConfiguration.Builder> ... var1);
    }
}

