/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;

public class ListBucketsPublisher
implements SdkPublisher<ListBucketsResponse> {
    private final S3AsyncClient client;
    private final ListBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBucketsPublisher(S3AsyncClient client, ListBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBucketsPublisher(S3AsyncClient client, ListBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBucketsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListBucketsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Bucket> buckets() {
        Function<ListBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.buckets() != null) {
                return response.buckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListBucketsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBucketsResponseFetcher
    implements AsyncPageFetcher<ListBucketsResponse> {
        private ListBucketsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.continuationToken());
        }

        @Override
        public CompletableFuture<ListBucketsResponse> nextPage(ListBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListBucketsPublisher.this.client.listBuckets(ListBucketsPublisher.this.firstRequest);
            }
            return ListBucketsPublisher.this.client.listBuckets((ListBucketsRequest)ListBucketsPublisher.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build());
        }
    }
}

