/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.internal;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SsoAccessToken
implements SdkToken {
    private final String accessToken;
    private final Instant expiresAt;

    private SsoAccessToken(BuilderImpl builder) {
        this.accessToken = Validate.paramNotNull(builder.accessToken, "accessToken");
        this.expiresAt = Validate.paramNotNull(builder.expiresAt, "expiresAt");
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public String token() {
        return this.accessToken;
    }

    @Override
    public Optional<Instant> expirationTime() {
        return Optional.of(this.expiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsoAccessToken ssoAccessToken = (SsoAccessToken)o;
        return Objects.equals(this.accessToken, ssoAccessToken.accessToken) && Objects.equals(this.expiresAt, ssoAccessToken.expiresAt);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.accessToken);
        result = 31 * result + Objects.hashCode(this.expiresAt);
        return result;
    }

    public String toString() {
        return ToString.builder("SsoAccessToken").add("accessToken", this.accessToken).add("expiresAt", this.expiresAt).build();
    }

    private static class BuilderImpl
    implements Builder {
        private String accessToken;
        private Instant expiresAt;

        private BuilderImpl() {
        }

        @Override
        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public SsoAccessToken build() {
            return new SsoAccessToken(this);
        }
    }

    public static interface Builder {
        public Builder accessToken(String var1);

        public Builder expiresAt(Instant var1);

        public SsoAccessToken build();
    }
}

