/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.internal;

import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.UserHomeDirectoryUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SsoTokenFileUtils {
    private static final Pattern HOME_DIRECTORY_PATTERN = Pattern.compile("^~(/|" + Pattern.quote(FileSystems.getDefault().getSeparator()) + ").*$");

    private SsoTokenFileUtils() {
    }

    public static Path generateCachedTokenPath(String startUrl, String tokenDirectory) {
        Validate.notNull(startUrl, "The start url shouldn't be null.", new Object[0]);
        byte[] startUrlBytes = startUrl.getBytes(StandardCharsets.UTF_8);
        String encodedUrl = new String(startUrlBytes, StandardCharsets.UTF_8);
        return SsoTokenFileUtils.resolveProfileFilePath(Paths.get(tokenDirectory, SsoTokenFileUtils.sha1Hex(encodedUrl) + ".json").toString());
    }

    private static String sha1Hex(String input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
            md.update(input.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw SdkClientException.builder().message("Unable to use \"SHA-1\" algorithm.").cause(e).build();
        }
        return BinaryUtils.toHex(md.digest());
    }

    private static Path resolveProfileFilePath(String path) {
        if (HOME_DIRECTORY_PATTERN.matcher(path).matches()) {
            path = UserHomeDirectoryUtils.userHomeDirectory() + path.substring(1);
        }
        return Paths.get(path, new String[0]);
    }
}

