/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssoadmin.model.Grant;
import software.amazon.awssdk.services.ssoadmin.model.GrantType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationGrantRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, PutApplicationGrantRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ApplicationArn").getter(PutApplicationGrantRequest.getter(PutApplicationGrantRequest::applicationArn)).setter(PutApplicationGrantRequest.setter(Builder::applicationArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("GrantType").getter(PutApplicationGrantRequest.getter(PutApplicationGrantRequest::grantTypeAsString)).setter(PutApplicationGrantRequest.setter(Builder::grantType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantType").build()).build();
    private static final SdkField<Grant> GRANT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Grant").getter(PutApplicationGrantRequest.getter(PutApplicationGrantRequest::grant)).setter(PutApplicationGrantRequest.setter(Builder::grant)).constructor(Grant::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grant").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, GRANT_TYPE_FIELD, GRANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutApplicationGrantRequest.memberNameToFieldInitializer();
    private final String applicationArn;
    private final String grantType;
    private final Grant grant;

    private PutApplicationGrantRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.grantType = builder.grantType;
        this.grant = builder.grant;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final GrantType grantType() {
        return GrantType.fromValue(this.grantType);
    }

    public final String grantTypeAsString() {
        return this.grantType;
    }

    public final Grant grant() {
        return this.grant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationGrantRequest)) {
            return false;
        }
        PutApplicationGrantRequest other = (PutApplicationGrantRequest)obj;
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.grantTypeAsString(), other.grantTypeAsString()) && Objects.equals(this.grant(), other.grant());
    }

    public final String toString() {
        return ToString.builder("PutApplicationGrantRequest").add("ApplicationArn", this.applicationArn()).add("GrantType", this.grantTypeAsString()).add("Grant", this.grant()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "GrantType": {
                return Optional.ofNullable(clazz.cast(this.grantTypeAsString()));
            }
            case "Grant": {
                return Optional.ofNullable(clazz.cast(this.grant()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("GrantType", GRANT_TYPE_FIELD);
        map.put("Grant", GRANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationGrantRequest, T> g) {
        return obj -> g.apply((PutApplicationGrantRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String grantType;
        private Grant grant;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationGrantRequest model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.grantType(model.grantType);
            this.grant(model.grant);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Override
        public final Builder grantType(GrantType grantType) {
            this.grantType(grantType == null ? null : grantType.toString());
            return this;
        }

        public final Grant.Builder getGrant() {
            return this.grant != null ? this.grant.toBuilder() : null;
        }

        public final void setGrant(Grant.BuilderImpl grant) {
            this.grant = grant != null ? grant.build() : null;
        }

        @Override
        public final Builder grant(Grant grant) {
            this.grant = grant;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationGrantRequest build() {
            return new PutApplicationGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutApplicationGrantRequest> {
        public Builder applicationArn(String var1);

        public Builder grantType(String var1);

        public Builder grantType(GrantType var1);

        public Builder grant(Grant var1);

        default public Builder grant(Consumer<Grant.Builder> grant) {
            return this.grant((Grant)Grant.builder().applyMutation(grant).build());
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

