/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssoadmin.model.SignInOrigin;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignInOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignInOptions> {
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Origin").getter(SignInOptions.getter(SignInOptions::originAsString)).setter(SignInOptions.setter(Builder::origin)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();
    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ApplicationUrl").getter(SignInOptions.getter(SignInOptions::applicationUrl)).setter(SignInOptions.setter(Builder::applicationUrl)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationUrl").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_FIELD, APPLICATION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignInOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String origin;
    private final String applicationUrl;

    private SignInOptions(BuilderImpl builder) {
        this.origin = builder.origin;
        this.applicationUrl = builder.applicationUrl;
    }

    public final SignInOrigin origin() {
        return SignInOrigin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final String applicationUrl() {
        return this.applicationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInOptions)) {
            return false;
        }
        SignInOptions other = (SignInOptions)obj;
        return Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.applicationUrl(), other.applicationUrl());
    }

    public final String toString() {
        return ToString.builder("SignInOptions").add("Origin", this.originAsString()).add("ApplicationUrl", this.applicationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "ApplicationUrl": {
                return Optional.ofNullable(clazz.cast(this.applicationUrl()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Origin", ORIGIN_FIELD);
        map.put("ApplicationUrl", APPLICATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignInOptions, T> g) {
        return obj -> g.apply((SignInOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String origin;
        private String applicationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SignInOptions model) {
            this.origin(model.origin);
            this.applicationUrl(model.applicationUrl);
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(SignInOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getApplicationUrl() {
            return this.applicationUrl;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @Override
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        @Override
        public SignInOptions build() {
            return new SignInOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignInOptions> {
        public Builder origin(String var1);

        public Builder origin(SignInOrigin var1);

        public Builder applicationUrl(String var1);
    }
}

