/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentForPrincipal;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse;

public class ListAccountAssignmentsForPrincipalIterable
implements SdkIterable<ListAccountAssignmentsForPrincipalResponse> {
    private final SsoAdminClient client;
    private final ListAccountAssignmentsForPrincipalRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAssignmentsForPrincipalIterable(SsoAdminClient client, ListAccountAssignmentsForPrincipalRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountAssignmentsForPrincipalResponseFetcher();
    }

    @Override
    public Iterator<ListAccountAssignmentsForPrincipalResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountAssignmentForPrincipal> accountAssignments() {
        Function<ListAccountAssignmentsForPrincipalResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignments() != null) {
                return response.accountAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountAssignmentsForPrincipalResponseFetcher
    implements SyncPageFetcher<ListAccountAssignmentsForPrincipalResponse> {
        private ListAccountAssignmentsForPrincipalResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountAssignmentsForPrincipalResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAccountAssignmentsForPrincipalResponse nextPage(ListAccountAssignmentsForPrincipalResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentsForPrincipalIterable.this.client.listAccountAssignmentsForPrincipal(ListAccountAssignmentsForPrincipalIterable.this.firstRequest);
            }
            return ListAccountAssignmentsForPrincipalIterable.this.client.listAccountAssignmentsForPrincipal((ListAccountAssignmentsForPrincipalRequest)ListAccountAssignmentsForPrincipalIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

