/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse;

public class ListApplicationAuthenticationMethodsIterable
implements SdkIterable<ListApplicationAuthenticationMethodsResponse> {
    private final SsoAdminClient client;
    private final ListApplicationAuthenticationMethodsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationAuthenticationMethodsIterable(SsoAdminClient client, ListApplicationAuthenticationMethodsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationAuthenticationMethodsResponseFetcher();
    }

    @Override
    public Iterator<ListApplicationAuthenticationMethodsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuthenticationMethodItem> authenticationMethods() {
        Function<ListApplicationAuthenticationMethodsResponse, Iterator> getIterator = response -> {
            if (response != null && response.authenticationMethods() != null) {
                return response.authenticationMethods().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationAuthenticationMethodsResponseFetcher
    implements SyncPageFetcher<ListApplicationAuthenticationMethodsResponse> {
        private ListApplicationAuthenticationMethodsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationAuthenticationMethodsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListApplicationAuthenticationMethodsResponse nextPage(ListApplicationAuthenticationMethodsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAuthenticationMethodsIterable.this.client.listApplicationAuthenticationMethods(ListApplicationAuthenticationMethodsIterable.this.firstRequest);
            }
            return ListApplicationAuthenticationMethodsIterable.this.client.listApplicationAuthenticationMethods((ListApplicationAuthenticationMethodsRequest)ListApplicationAuthenticationMethodsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

