/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationProvider;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse;

public class ListApplicationProvidersIterable
implements SdkIterable<ListApplicationProvidersResponse> {
    private final SsoAdminClient client;
    private final ListApplicationProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationProvidersIterable(SsoAdminClient client, ListApplicationProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationProvidersResponseFetcher();
    }

    @Override
    public Iterator<ListApplicationProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationProvider> applicationProviders() {
        Function<ListApplicationProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationProviders() != null) {
                return response.applicationProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationProvidersResponseFetcher
    implements SyncPageFetcher<ListApplicationProvidersResponse> {
        private ListApplicationProvidersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListApplicationProvidersResponse nextPage(ListApplicationProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationProvidersIterable.this.client.listApplicationProviders(ListApplicationProvidersIterable.this.firstRequest);
            }
            return ListApplicationProvidersIterable.this.client.listApplicationProviders((ListApplicationProvidersRequest)ListApplicationProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

