/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.Application;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse;

public class ListApplicationsPublisher
implements SdkPublisher<ListApplicationsResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationsPublisher(SsoAdminAsyncClient client, ListApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationsPublisher(SsoAdminAsyncClient client, ListApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListApplicationsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Application> applications() {
        Function<ListApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applications() != null) {
                return response.applications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationsResponseFetcher
    implements AsyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListApplicationsResponse> nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsPublisher.this.client.listApplications(ListApplicationsPublisher.this.firstRequest);
            }
            return ListApplicationsPublisher.this.client.listApplications((ListApplicationsRequest)ListApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

