/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;

public class ListManagedPoliciesInPermissionSetIterable
implements SdkIterable<ListManagedPoliciesInPermissionSetResponse> {
    private final SsoAdminClient client;
    private final ListManagedPoliciesInPermissionSetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedPoliciesInPermissionSetIterable(SsoAdminClient client, ListManagedPoliciesInPermissionSetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedPoliciesInPermissionSetResponseFetcher();
    }

    @Override
    public Iterator<ListManagedPoliciesInPermissionSetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttachedManagedPolicy> attachedManagedPolicies() {
        Function<ListManagedPoliciesInPermissionSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedManagedPolicies() != null) {
                return response.attachedManagedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedPoliciesInPermissionSetResponseFetcher
    implements SyncPageFetcher<ListManagedPoliciesInPermissionSetResponse> {
        private ListManagedPoliciesInPermissionSetResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListManagedPoliciesInPermissionSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListManagedPoliciesInPermissionSetResponse nextPage(ListManagedPoliciesInPermissionSetResponse previousPage) {
            if (previousPage == null) {
                return ListManagedPoliciesInPermissionSetIterable.this.client.listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetIterable.this.firstRequest);
            }
            return ListManagedPoliciesInPermissionSetIterable.this.client.listManagedPoliciesInPermissionSet((ListManagedPoliciesInPermissionSetRequest)ListManagedPoliciesInPermissionSetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

