/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata;

public class ListTrustedTokenIssuersPublisher
implements SdkPublisher<ListTrustedTokenIssuersResponse> {
    private final SsoAdminAsyncClient client;
    private final ListTrustedTokenIssuersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrustedTokenIssuersPublisher(SsoAdminAsyncClient client, ListTrustedTokenIssuersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrustedTokenIssuersPublisher(SsoAdminAsyncClient client, ListTrustedTokenIssuersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrustedTokenIssuersResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListTrustedTokenIssuersResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrustedTokenIssuerMetadata> trustedTokenIssuers() {
        Function<ListTrustedTokenIssuersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustedTokenIssuers() != null) {
                return response.trustedTokenIssuers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListTrustedTokenIssuersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrustedTokenIssuersResponseFetcher
    implements AsyncPageFetcher<ListTrustedTokenIssuersResponse> {
        private ListTrustedTokenIssuersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListTrustedTokenIssuersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListTrustedTokenIssuersResponse> nextPage(ListTrustedTokenIssuersResponse previousPage) {
            if (previousPage == null) {
                return ListTrustedTokenIssuersPublisher.this.client.listTrustedTokenIssuers(ListTrustedTokenIssuersPublisher.this.firstRequest);
            }
            return ListTrustedTokenIssuersPublisher.this.client.listTrustedTokenIssuers((ListTrustedTokenIssuersRequest)ListTrustedTokenIssuersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

