/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.ssooidc.auth.scheme.SsoOidcAuthSchemeParams;
import software.amazon.awssdk.services.ssooidc.auth.scheme.SsoOidcAuthSchemeProvider;

@SdkInternalApi
public final class DefaultSsoOidcAuthSchemeProvider
implements SsoOidcAuthSchemeProvider {
    private static final DefaultSsoOidcAuthSchemeProvider DEFAULT = new DefaultSsoOidcAuthSchemeProvider();

    private DefaultSsoOidcAuthSchemeProvider() {
    }

    public static DefaultSsoOidcAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(SsoOidcAuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "CreateToken": 
            case "RegisterClient": 
            case "StartDeviceAuthorization": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, "sso-oauth").putSignerProperty(AwsV4HttpSigner.REGION_NAME, params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

