/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.internal;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.internal.token.TokenTransformer;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcToken;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SsoOidcTokenTransformer
implements TokenTransformer<SsoOidcToken, CreateTokenResponse> {
    private final SsoOidcToken baseToken;

    private SsoOidcTokenTransformer(SsoOidcToken baseToken) {
        Validate.notNull(baseToken.startUrl(), "startUrl is null ", new Object[0]);
        Validate.notNull(baseToken.clientId(), "clientId is null ", new Object[0]);
        Validate.notNull(baseToken.clientSecret(), "clientSecret is null ", new Object[0]);
        this.baseToken = baseToken;
    }

    public static SsoOidcTokenTransformer create(SsoOidcToken baseToken) {
        Validate.paramNotNull(baseToken, "baseToken");
        return new SsoOidcTokenTransformer(baseToken);
    }

    @Override
    public SsoOidcToken transform(CreateTokenResponse awsResponse) {
        Validate.paramNotNull(awsResponse.accessToken(), "accessToken");
        Validate.paramNotNull(awsResponse.expiresIn(), "expiresIn");
        return SsoOidcToken.builder().accessToken(awsResponse.accessToken()).refreshToken(awsResponse.refreshToken()).expiresAt(awsResponse.expiresIn() != null ? Instant.now().plusSeconds(awsResponse.expiresIn().intValue()) : null).startUrl(this.baseToken.startUrl()).registrationExpiresAt(this.baseToken.registrationExpiresAt()).region(this.baseToken.region()).clientSecret(this.baseToken.clientSecret()).clientId(this.baseToken.clientId()).providerName("SsoOidcTokenProvider").build();
    }
}

