/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsServiceClientConfiguration;
import software.amazon.awssdk.services.sts.internal.StsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.AssumeRootRequest;
import software.amazon.awssdk.services.sts.model.AssumeRootResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.awssdk.services.sts.model.ExpiredTradeInTokenException;
import software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest;
import software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetDelegatedAccessTokenRequest;
import software.amazon.awssdk.services.sts.model.GetDelegatedAccessTokenResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import software.amazon.awssdk.services.sts.model.IdpRejectedClaimException;
import software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.awssdk.services.sts.model.StsException;
import software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRootRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetAccessKeyInfoRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetDelegatedAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultStsAsyncClient
implements StsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultStsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.QUERY).build();
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "STS#2.38.x").build();
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<AssumeRoleResponse> assumeRole(AssumeRoleRequest assumeRoleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(assumeRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, assumeRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRole");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRole").withProtocolMetadata(protocolMetadata).withMarshaller(new AssumeRoleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(assumeRoleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<AssumeRoleWithSamlResponse> assumeRoleWithSAML(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(assumeRoleWithSamlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, assumeRoleWithSamlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoleWithSAML");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithSamlResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithSAML").withProtocolMetadata(protocolMetadata).withMarshaller(new AssumeRoleWithSamlRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(assumeRoleWithSamlRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<AssumeRoleWithWebIdentityResponse> assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(assumeRoleWithWebIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, assumeRoleWithWebIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoleWithWebIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithWebIdentityResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithWebIdentity").withProtocolMetadata(protocolMetadata).withMarshaller(new AssumeRoleWithWebIdentityRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(assumeRoleWithWebIdentityRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<AssumeRootResponse> assumeRoot(AssumeRootRequest assumeRootRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(assumeRootRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, assumeRootRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRootResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoot").withProtocolMetadata(protocolMetadata).withMarshaller(new AssumeRootRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(assumeRootRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DecodeAuthorizationMessageResponse> decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(decodeAuthorizationMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, decodeAuthorizationMessageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecodeAuthorizationMessage");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DecodeAuthorizationMessageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecodeAuthorizationMessage").withProtocolMetadata(protocolMetadata).withMarshaller(new DecodeAuthorizationMessageRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(decodeAuthorizationMessageRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetAccessKeyInfoResponse> getAccessKeyInfo(GetAccessKeyInfoRequest getAccessKeyInfoRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getAccessKeyInfoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, getAccessKeyInfoRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessKeyInfo");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetAccessKeyInfoResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessKeyInfo").withProtocolMetadata(protocolMetadata).withMarshaller(new GetAccessKeyInfoRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getAccessKeyInfoRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCallerIdentityResponse> getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCallerIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, getCallerIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCallerIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCallerIdentityResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCallerIdentity").withProtocolMetadata(protocolMetadata).withMarshaller(new GetCallerIdentityRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getCallerIdentityRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetDelegatedAccessTokenResponse> getDelegatedAccessToken(GetDelegatedAccessTokenRequest getDelegatedAccessTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDelegatedAccessTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, getDelegatedAccessTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDelegatedAccessToken");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetDelegatedAccessTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDelegatedAccessToken").withProtocolMetadata(protocolMetadata).withMarshaller(new GetDelegatedAccessTokenRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getDelegatedAccessTokenRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetFederationTokenResponse> getFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getFederationTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, getFederationTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFederationToken");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFederationTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFederationToken").withProtocolMetadata(protocolMetadata).withMarshaller(new GetFederationTokenRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getFederationTokenRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetSessionTokenResponse> getSessionToken(GetSessionTokenRequest getSessionTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getSessionTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(clientConfiguration, getSessionTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionToken");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSessionTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionToken").withProtocolMetadata(protocolMetadata).withMarshaller(new GetSessionTokenRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getSessionTokenRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final StsServiceClientConfiguration serviceClientConfiguration() {
        return new StsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return "sts";
    }

    private AwsQueryProtocolFactory init() {
        return ((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorizationMessageException").exceptionBuilderSupplier(InvalidAuthorizationMessageException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTokenException").exceptionBuilderSupplier(ExpiredTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("PackedPolicyTooLarge").exceptionBuilderSupplier(PackedPolicyTooLargeException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("RegionDisabledException").exceptionBuilderSupplier(RegionDisabledException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocument").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTradeInTokenException").exceptionBuilderSupplier(ExpiredTradeInTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IDPRejectedClaim").exceptionBuilderSupplier(IdpRejectedClaimException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIdentityToken").exceptionBuilderSupplier(InvalidIdentityTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IDPCommunicationError").exceptionBuilderSupplier(IdpCommunicationErrorException::builder).httpStatusCode(400).build())).clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(StsException::builder)).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        StsServiceClientConfigurationBuilder serviceConfigBuilder = new StsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

