/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.StsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDelegatedAccessTokenResponse
extends StsResponse
implements ToCopyableBuilder<Builder, GetDelegatedAccessTokenResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Credentials").getter(GetDelegatedAccessTokenResponse.getter(GetDelegatedAccessTokenResponse::credentials)).setter(GetDelegatedAccessTokenResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();
    private static final SdkField<Integer> PACKED_POLICY_SIZE_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("PackedPolicySize").getter(GetDelegatedAccessTokenResponse.getter(GetDelegatedAccessTokenResponse::packedPolicySize)).setter(GetDelegatedAccessTokenResponse.setter(Builder::packedPolicySize)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackedPolicySize").build()).build();
    private static final SdkField<String> ASSUMED_PRINCIPAL_FIELD = SdkField.builder(MarshallingType.STRING).memberName("AssumedPrincipal").getter(GetDelegatedAccessTokenResponse.getter(GetDelegatedAccessTokenResponse::assumedPrincipal)).setter(GetDelegatedAccessTokenResponse.setter(Builder::assumedPrincipal)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumedPrincipal").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, PACKED_POLICY_SIZE_FIELD, ASSUMED_PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDelegatedAccessTokenResponse.memberNameToFieldInitializer();
    private final Credentials credentials;
    private final Integer packedPolicySize;
    private final String assumedPrincipal;

    private GetDelegatedAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.packedPolicySize = builder.packedPolicySize;
        this.assumedPrincipal = builder.assumedPrincipal;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public final String assumedPrincipal() {
        return this.assumedPrincipal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.packedPolicySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedPrincipal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegatedAccessTokenResponse)) {
            return false;
        }
        GetDelegatedAccessTokenResponse other = (GetDelegatedAccessTokenResponse)obj;
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.packedPolicySize(), other.packedPolicySize()) && Objects.equals(this.assumedPrincipal(), other.assumedPrincipal());
    }

    public final String toString() {
        return ToString.builder("GetDelegatedAccessTokenResponse").add("Credentials", this.credentials()).add("PackedPolicySize", this.packedPolicySize()).add("AssumedPrincipal", this.assumedPrincipal()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "PackedPolicySize": {
                return Optional.ofNullable(clazz.cast(this.packedPolicySize()));
            }
            case "AssumedPrincipal": {
                return Optional.ofNullable(clazz.cast(this.assumedPrincipal()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("PackedPolicySize", PACKED_POLICY_SIZE_FIELD);
        map.put("AssumedPrincipal", ASSUMED_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDelegatedAccessTokenResponse, T> g) {
        return obj -> g.apply((GetDelegatedAccessTokenResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StsResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private Integer packedPolicySize;
        private String assumedPrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegatedAccessTokenResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.packedPolicySize(model.packedPolicySize);
            this.assumedPrincipal(model.assumedPrincipal);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final String getAssumedPrincipal() {
            return this.assumedPrincipal;
        }

        public final void setAssumedPrincipal(String assumedPrincipal) {
            this.assumedPrincipal = assumedPrincipal;
        }

        @Override
        public final Builder assumedPrincipal(String assumedPrincipal) {
            this.assumedPrincipal = assumedPrincipal;
            return this;
        }

        @Override
        public GetDelegatedAccessTokenResponse build() {
            return new GetDelegatedAccessTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDelegatedAccessTokenResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)Credentials.builder().applyMutation(credentials).build());
        }

        public Builder packedPolicySize(Integer var1);

        public Builder assumedPrincipal(String var1);
    }
}

